// Uncharted 2 filmic tonemapping constants
// http://filmicgames.com/archives/75
static const float A = 0.15;
static const float B = 0.50;
static const float C = 0.10;
static const float D = 0.20;
static const float E = 0.02;
static const float F = 0.30;
static const float W = 11.2;

float3 Uncharted2Tonemap(float3 x) {
	return ((x*(A*x+C*B)+D*E)/(x*(A*x+B)+D*F))-E/F;
}

float4 ApplyTonemapping(float4 hdrColor) {
	// Exposure modification
	hdrColor.rgb *= ExposureModifier;

	// Filmic Tonemapping
	// Hardcoded exposure adjustment
	const float ExposureBias = 0.01;
	float3 curr = Uncharted2Tonemap(ExposureBias * hdrColor.rgb); 
	float3 whiteScale = 1.0 / Uncharted2Tonemap(W);

	return float4(curr * whiteScale, hdrColor.a);;
}